<?php 
function phperiodical_colors_customize_register($wp_customize) {
	
	$wp_customize->get_control('header_textcolor')->label = __('Site Title Color','ph-periodical');
	$wp_customize->get_section('colors')->title = __('Website Color Scheme','ph-periodical');
	
	$wp_customize->add_setting(
		'phperiodical-background-darker-color', array(
			'default'	=>	'#EEEEEE',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-background-darker-color', array(
				'label'		=>	__('Background (Darker Shade)', 'ph-periodical'),
				'description' =>	__('A Slightly darker shade of the main background color. Helpful in adding accents to the design.', 'ph-periodical'),
				'section'	=>	'colors',
				'settings'	=>	'phperiodical-background-darker-color',
				'priority'	=>	30
			)	
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-primary-color', array(
			'default'	=>	'#3C3B6E',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-primary-color', array(
				'label'		=>	__('Primary Color', 'ph-periodical'),
				'section'	=>	'colors',
				'settings'	=>	'phperiodical-primary-color',
				'priority'	=>	30
			)	
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-primary-text-color', array(
			'default'	=>	'#f9ffe7',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-primary-text-color', array(
				'label'		=>	__('Primary Text Color', 'ph-periodical'),
				'description' => __('This is the color of the text, where the background color is Primary color. Like Menu Bar, Buttons, etc.', 'ph-periodical'),
				'section'	=>	'colors',
				'settings'	=>	'phperiodical-primary-text-color',
				'priority'	=>	30
			)	
		)
	);
	
	//Secondary
	$wp_customize->add_setting(
		'phperiodical-secondary-color', array(
			'default'	=>	'#4a58d9',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-secondary-color', array(
				'label'		=>	__('Secondary Color', 'ph-periodical'),
				'description' => __('Secondary Color. Used for Links within content, sidebar, etc.', 'ph-periodical'),
				'section'	=>	'colors',
				'settings'	=>	'phperiodical-secondary-color',
				'priority'	=>	30
			)	
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-secondary-text-color', array(
			'default'	=>	'#f9ffe7',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-secondary-text-color', array(
				'label'		=>	__('Secondary Text Color', 'ph-periodical'),
				'description' => __('This is the color of the text, where the background color is Secondary color. Like Module Headings, Some Buttons, etc.', 'ph-periodical'),
				'section'	=>	'colors',
				'settings'	=>	'phperiodical-secondary-text-color',
				'priority'	=>	30
			)	
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-secondary-dark-color', array(
			'default'	=>	'#5241c1',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-secondary-dark-color', array(
				'label'		=>	__('Secondary Color (Darker Shade)', 'ph-periodical'),
				'description' => __('Darker shade of Secondary color. Used on Link Hover, etc.', 'ph-periodical'),
				'section'	=>	'colors',
				'settings'	=>	'phperiodical-secondary-dark-color',
				'priority'	=>	30
			)	
		)
	);
	
	//Text Colors.
	$wp_customize->add_setting(
		'phperiodical-text-color', array(
			'default'	=>	'#555555',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-text-color', array(
				'label'		=>	__('Text Color', 'ph-periodical'),
				'description' =>	__('Text Color. Main color of the content.', 'ph-periodical'),
				'section'	=>	'colors',
				'settings'	=>	'phperiodical-text-color',
				'priority'	=>	30
			)	
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-text-dark-color', array(
			'default'	=>	'#111111',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-text-dark-color', array(
				'label'		=>	__('Text Color (Darker shade)', 'ph-periodical'),
				'description' =>	__('Darker Shade of the text color. Used for headings and important text.', 'ph-periodical'),
				'section'	=>	'colors',
				'settings'	=>	'phperiodical-text-dark-color',
				'priority'	=>	30
			)	
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-text-light-color', array(
			'default'	=>	'#777777',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-text-light-color', array(
				'label'		=>	__('Text Color (Lighter Shade)', 'ph-periodical'),
				'description' =>	__('Lighter Shade of Text Color. Used for Top Menu, Meta Data and other text.', 'ph-periodical'),
				'section'	=>	'colors',
				'settings'	=>	'phperiodical-text-light-color',
				'priority'	=>	30
			)	
		)
	);
		
}
add_action('customize_register','phperiodical_colors_customize_register');