<?php
/*
* Header Customization Panel
* Site Identity (Desktop Logo Width, Logo Mobile)
* Section - Header Image
* Section - Header Settings - Top Bar (enable, disable). Date (Enable/disable), Search form (enable/disable)
* Section - Header Mobile
*/
function phperiodical_header_customize_register($wp_customize) {

	$wp_customize->add_panel(
		'phperiodical-header-settings', array(
			'title'		=>	__('Header Settings', 'ph-periodical'),
			'priority'	=>	20
		)
	);
	
	$wp_customize->get_section('title_tagline')->panel = 'phperiodical-header-settings';
	$wp_customize->get_section('title_tagline')->priority = 5;
	$wp_customize->get_section('header_image')->panel = 'phperiodical-header-settings';
	$wp_customize->get_section('header_image')->priority = 5;
	
	//Logo
	$wp_customize->add_setting( 'phperiodical-logo-max-height', array(
		'default' => 90,
		'sanitize_callback' => 'absint'
	));
	
	$wp_customize->add_control( new WP_Customize_Control(
		$wp_customize,
		'phperiodical-logo-max-height',
			array(
				'label'    => __( 'Logo height (in pixels)', 'ph-periodical' ),
				'description'    => __( 'Adjust Height of Logo in desktop view if its too large. This only affects the maximum height. If your logo is small, it will not make it bigger.', 'ph-periodical' ),
				'section'  => 'title_tagline',
				'settings' => 'phperiodical-logo-max-height',
				'priority' => 5,
				'type'     => 'range',
				'input_attrs' => array(
					'min' => 30,
					'max' => 100,
					'step' => 1,
				  )
			)
		)
	);
	
	$wp_customize->add_setting( 'phperiodical-mobile-logo', array(
		'sanitize_callback' => 'esc_url_raw'
	));
 
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'phperiodical-mobile-logo-control', array(
		'label' => __('Mobile Logo (optional)','ph-periodical'),
		'description' => __('If you want a different logo to be used for mobile devices, you can use this setting. By Default, Main Logo will be shown for Desktop and Mobile both.','ph-periodical'),
		'priority' => 100,
		'section' => 'title_tagline',
		'settings' => 'phperiodical-mobile-logo',
		'button_labels' => array(// All These labels are optional
					'select' => __('Select Logo','ph-periodical'),
					'remove' => __('Remove Logo','ph-periodical'),
					'change' => __('Change Logo','ph-periodical'),
					)
	)));
	
	//Header Image
	$wp_customize->add_setting('pixahive-header-image-message', array(
		'sanitize_callback'	=>	'sanitize_text_field' 
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_Custom_Notice_Control(
			$wp_customize, 'pixahive-header-image-message', array(
				'label'		=>	__('Note:', 'ph-periodical'),
				'description'	=>	__('Header Image only appears when you choose Style 1 in <strong>Header Styles (Desktop)</strong>. Header image doesn\'t appear when Style 2 is selected.', 'ph-periodical'),
				'priority'		=>	1,
				'section'		=>	'header_image',
			)
		)
	);
	
	//Styles & Layouts
	$wp_customize->add_section(
		'phperiodical-header-styles-layouts', array(
			'title'		=>	__('Header Style (Desktop)', 'ph-periodical'),
			'priority'	=>	30,
			'panel'		=>	'phperiodical-header-settings'
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-header-style', array(
			'default' => 'style4',
			'sanitize_callback'	=>	'phperiodical_sanitize_fa_style'
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_Image_Radio_Control($wp_customize, 
			'phperiodical-header-style', array(
				'type' => 'radio',
				'label' => esc_html__('Select Header Style', 'ph-periodical'),
				'section' => 'phperiodical-header-styles-layouts',
				'settings' => 'phperiodical-header-style',
				'choices' => array(
					'style1' => get_template_directory_uri() . '/inc/customizer/images/header-style1.png',
					'style2' => get_template_directory_uri() . '/inc/customizer/images/header-style2.png',
					'style3' => get_template_directory_uri() . '/inc/customizer/images/header-style3.png',
					'style4' => get_template_directory_uri() . '/inc/customizer/images/header-style4.png',
				)
			)
		)
	);
	
	//Colors (FOR STYLE 2 Only)
	$wp_customize->add_setting(
		'phperiodical-header-bg-color', array(
			'default'	=>	'#B12334',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-header-bg-color', array(
				'label'		=>	esc_html__('Header Background Color', 'ph-periodical'),
				'section'	=>	'phperiodical-header-styles-layouts',
				'settings'	=>	'phperiodical-header-bg-color',
				'priority'	=>	30,
				'active_callback' => function($control) {
					return (
						'style2' == $control->manager->get_setting('phperiodical-header-style')->value()
						||
						'style3' == $control->manager->get_setting('phperiodical-header-style')->value()
						||
						'style4' == $control->manager->get_setting('phperiodical-header-style')->value()
					);
				}
			)	
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-header-bg-lighter-color', array(
			'default'	=>	'#af4652',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-header-bg-lighter-color', array(
				'label'		=>	esc_html__('Header Background (Lighter Shade)', 'ph-periodical'),
				'description'	=>	esc_html__('Background color of social icons & search bar.', 'ph-periodical'),
				'section'	=>	'phperiodical-header-styles-layouts',
				'settings'	=>	'phperiodical-header-bg-lighter-color',
				'priority'	=>	30,
				'active_callback' => function($control) {
					return (
						//when style2 is enabled
						'style2' == $control->manager->get_setting('phperiodical-header-style')->value()
						||
						//when style3 is enabled
						'style3' == $control->manager->get_setting('phperiodical-header-style')->value()	
						||
						'style4' == $control->manager->get_setting('phperiodical-header-style')->value()					
					);
				}
			)	
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-top-bar-text-color', array(
			'default'	=>	'#777777',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-top-bar-text-color', array(
				'label'		=>	esc_html__('Top Bar Text Color', 'ph-periodical'),
				'section'	=>	'phperiodical-header-styles-layouts',
				'settings'	=>	'phperiodical-top-bar-text-color',
				'priority'	=>	30,
				'active_callback' => function($control) {
					return (
						(true == $control->manager->get_setting('phperiodical-enable-top-bar')->value())
						&&
						(
							'style2' == $control->manager->get_setting('phperiodical-header-style')->value() 
							||
							'style4' == $control->manager->get_setting('phperiodical-header-style')->value()	
						)
					);
				}
			)	
		)
	);
	
	//Gradient for Header Background [Style3 Only]
	$wp_customize->add_setting(
		'phperiodical-enable-header-gradient', array(
			'default'		=>	1,
			'sanitize_callback'	=>	'absint' 
		)
	);
		
	$wp_customize->add_control(
		'phperiodical-enable-header-gradient', array(
			  'type' => 'checkbox',
			  'section'		=>	'phperiodical-header-styles-layouts',
			  'label' => __( 'Enable Header Gradient','ph-periodical' ),
			  'description' => __( 'This enables you to choose 2 colors for Header.','ph-periodical' ),
			  'active_callback' => function($control) {
				  return ('style3' == $control->manager->get_setting('phperiodical-header-style')->value());
			  }
			)	
	);
	
	$wp_customize->add_setting(
		'phperiodical-header-gradient-left', array(
			'default'	=>	'#c90000',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-header-gradient-left', array(
				'label'		=>	esc_html__('Header Gradient (Left)', 'ph-periodical'),
				'section'	=>	'phperiodical-header-styles-layouts',
				'settings'	=>	'phperiodical-header-gradient-left',
				'priority'	=>	29,
				'active_callback' => function($control) {
					return (
						(true == $control->manager->get_setting('phperiodical-enable-header-gradient')->value())
						&&
						('style3' == $control->manager->get_setting('phperiodical-header-style')->value())
					);
				}
			)	
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-header-gradient-right', array(
			'default'	=>	'#8158ff',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-header-gradient-right', array(
				'label'		=>	esc_html__('Header Gradient (Right)', 'ph-periodical'),
				'section'	=>	'phperiodical-header-styles-layouts',
				'settings'	=>	'phperiodical-header-gradient-right',
				'priority'	=>	29,
				'active_callback' => function($control) {
					return (
						(true == $control->manager->get_setting('phperiodical-enable-header-gradient')->value())
						&&
						('style3' == $control->manager->get_setting('phperiodical-header-style')->value())
					);
				}
			)	
		)
	);
	
	
	//END Header Gradient
	
	//social icon/text color
	$wp_customize->add_setting(
		'phperiodical-header-content-color', array(
			'default'	=>	'#FFFFFF',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-header-content-color', array(
				'label'		=>	esc_html__('Header content Color', 'ph-periodical'),
				'description'	=>	esc_html__('Used by social icons, search bar, or menu in some layouts.', 'ph-periodical'),
				'section'	=>	'phperiodical-header-styles-layouts',
				'settings'	=>	'phperiodical-header-content-color',
				'priority'	=>	30,
				'active_callback' => function($control) {
					return (
						'style2' == $control->manager->get_setting('phperiodical-header-style')->value() 
						|| 
						'style3' == $control->manager->get_setting('phperiodical-header-style')->value() 
						||
						'style4' == $control->manager->get_setting('phperiodical-header-style')->value()	
				);
				}
			)	
		)
	);
	
	//Enable Top Bar
	$wp_customize->add_setting(
		'phperiodical-enable-top-bar', array(
			'default'		=>	0,
			'sanitize_callback'	=>	'absint' 
		)
	);
		
	$wp_customize->add_control(
		'phperiodical-enable-top-bar', array(
			  'type' => 'checkbox',
			  'section'		=>	'phperiodical-header-styles-layouts',
			  'label' => __( 'Enable Top Bar','ph-periodical' ),
			  'description' => __( 'This enables an additional top bar above header containing Top Menu on the right, and Date on left.','ph-periodical' ),
			  'active_callback' => function($control) {
				  return (
					  'style2' == $control->manager->get_setting('phperiodical-header-style')->value()
					  ||
					  'style4' == $control->manager->get_setting('phperiodical-header-style')->value()	
				  );
			  }
			)	
	);
	
	$wp_customize->add_setting(
		'phperiodical-enable-date', array(
			'default'		=>	1,
			'sanitize_callback'	=>	'absint' 
		)
	);
		
	$wp_customize->add_control(
		'phperiodical-enable-date', array(
			  'type' => 'checkbox',
			  'section'		=>	'phperiodical-header-styles-layouts',
			  'label' => __( 'Enable Date in Top Bar','ph-periodical' ),
			  'active_callback' => function($control) {
				  return (
					  (true == $control->manager->get_setting('phperiodical-enable-top-bar')->value())
					  &&
					  (
						  'style2' == $control->manager->get_setting('phperiodical-header-style')->value()
						  ||
						  'style4' == $control->manager->get_setting('phperiodical-header-style')->value()	
					  )
				  );
			  },
			  
			)	
	);
	
	//Header (Mobile)
	$wp_customize->add_section(
		'phperiodical-header-mobile', array(
			'title'		=>	__('Header Style (Mobile)', 'ph-periodical'),
			'priority'	=>	30,
			'panel'		=>	'phperiodical-header-settings'
		)
	);
	
	$wp_customize->add_setting('pixahive-header-mobile-message', array(
		'sanitize_callback'	=>	'sanitize_text_field' 
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_Custom_Notice_Control(
			$wp_customize, 'pixahive-header-mobile-message', array(
				'label'		=>	__('Header (Mobile)', 'ph-periodical'),
				'description'	=>	__('For a Better User experience, PH Periodical uses a smaller Mobile Header with just the logo and Menu Icon. The Search Bar, Social Icons, Complete Menu appear when the Hamburger (<span class="dashicons dashicons-menu-alt"></span>) Icon is clicked.', 'ph-periodical'),
				'priority'		=>	1,
				'section'		=>	'phperiodical-header-mobile',
			)
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-header-mobile-bg-color', array(
			'default'	=>	'#FFFFFF',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-header-mobile-bg-color', array(
				'label'		=>	esc_html__('Header Background Color', 'ph-periodical'),
				'section'	=>	'phperiodical-header-mobile',
				'settings'	=>	'phperiodical-header-mobile-bg-color',
				'priority'	=>	30,
			)	
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-header-mobile-text-color', array(
			'default'	=>	'#222222',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize, 'phperiodical-header-mobile-text-color', array(
				'label'		=>	esc_html__('Header Content Color (Title/Icons)', 'ph-periodical'),
				'section'	=>	'phperiodical-header-mobile',
				'settings'	=>	'phperiodical-header-mobile-text-color',
				'priority'	=>	30,
			)	
		)
	);
	
	
	//Social
	$wp_customize->add_section(
		'phperiodical-social-links', array(
			'title'		=>	__('Social Links', 'ph-periodical'),
			'priority'	=>	30,
			'panel'		=>	'phperiodical-header-settings'
		)
	);
	
	$wp_customize->add_setting('pixahive-social-message', array(
		'sanitize_callback'	=>	'sanitize_text_field' 
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_Custom_Notice_Control(
			$wp_customize, 'pixahive-social-message', array(
				'label'		=>	__('How to Set up Social Icons in Header?', 'ph-periodical'),
				'description'	=>	__('PH Periodical themes supports social icons via WordPress menus. Its really easy to add and the info is retained when you switch themes. Here is how you do it. <br><br><strong>Step 1. </strong>Go to Appearance > Menus. Create a New Menu. <br><strong>Step 2. </strong>Add Menu Item. Choose Custom Links. Enter your Social Profile URL. Leave the <em>Link Text</em> field blank. Repeat for all social networks you want to display.<br><strong>Step 3. </strong>Choose Menu location as Social Networks, and press Save. <br><br>PH Periodical theme is smart enough and will automatically connect your social urls with correct icons. The theme supports all top social networks.', 'ph-periodical'),
				'priority'		=>	1,
				'section'		=>	'phperiodical-social-links',
			)
		)
	);
	
}
add_action('customize_register','phperiodical_header_customize_register');