<?php
/*
* Custom Copyright Text
* Enable Additional Footer Menu
* 
*/
function phperiodical_footer_customize_register($wp_customize) {

	$wp_customize->add_panel(
		'phperiodical-footer-panel', array(
			'title'		=>	__('Footer Settings', 'ph-periodical'),
			'priority'	=>	20
		)
	);
	
	$wp_customize->add_section(
		'phperiodical-footer-section', array(
			'title'		=>	__('Copyright Text', 'ph-periodical'),
			'panel'		=> 'phperiodical-footer-panel',
			'priority'	=>	20
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-copyright-text', array(
			'sanitize_callback'	=>	'sanitize_text_field', 
			'default'		=>	__('&copy; ','ph-periodical').esc_html(get_bloginfo('name')).__(" ", 'ph-periodical').date('Y'),
			
		)
	);
	
	$wp_customize->add_control(
		'phperiodical-copyright-text', array(
			  'type' => 'text',
			  'section'		=>	'phperiodical-footer-section',
			  'label' => __( 'Copyright Text','ph-periodical' ),
			  'description' => __( 'Enter your own Copyright text. Default Copyright Message is (c) Sitename and Year.','ph-periodical' ),
			)	
	);
		
}
add_action('customize_register','phperiodical_footer_customize_register');