<?php
/**
 *	Featured Areas
 */
function phperiodical_featured_areas_customize_register( $wp_customize ) {
	
	
	//Featured Areas
	$wp_customize->add_panel(
		'phperiodical-featured-areas', array(
			'title'		=>	__('Featured Areas', 'ph-periodical'),
			'priority'	=>	30
		)
	);
	
	//Ticker
	$wp_customize->add_section(
		'phperiodical-ticker', array(
			'title'		=>	__('Featured Ticker', 'ph-periodical'),
			'priority'	=>	10,
			'panel'		=>	'phperiodical-featured-areas'
		)
		);
		
	$wp_customize->add_setting(
		'phperiodical-enable-ticker', array(
			'default'		=>	0,
			'sanitize_callback'	=>	'absint' 
		)
	);
		
	$wp_customize->add_control(
		'phperiodical-enable-ticker', array(
			  'type' => 'checkbox',
			  'section'		=>	'phperiodical-ticker',
			  'label' => __( 'Enable ticker (Homepage Only)','ph-periodical' ),
			  'description' => __( 'Animated Ticker generally used to show viral or trending content.','ph-periodical' ),
			)	
	);
	
	$wp_customize->add_setting(
		'phperiodical-enable-ticker-sitewide', array(
			'default'		=>	0,
			'sanitize_callback'	=>	'absint' 
		)
	);
		
	$wp_customize->add_control(
		'phperiodical-enable-ticker-sitewide', array(
			  'type' => 'checkbox',
			  'section'		=>	'phperiodical-ticker',
			  'label' => __( 'Enable Ticker (Sitewide)','ph-periodical' ),
			)	
	);
	
	$wp_customize->add_setting(
		'phperiodical-ticker-label', array(
			'default'		=>	__('Latest Posts', 'ph-periodical'),
			'sanitize_callback'	=>	'sanitize_text_field' 
		)
	);
		
	$wp_customize->add_control(
		'phperiodical-ticker-label', array(
			  'type' => 'text',
			  'section'		=>	'phperiodical-ticker',
			  'label' => __( 'Ticker Label','ph-periodical' ),
			)	
	);
		
	$wp_customize->add_setting(
		'phperiodical-ticker-cat', array(
			'default'		=>	0,
			'sanitize_callback'	=>	'absint'
		)
	);
	
		
	$wp_customize->add_control(
		new phperiodical_WP_Customize_Category_Control(
			$wp_customize, 'phperiodical-ticker-cat', array(
				'label'		=>	__('Category', 'ph-periodical'),
				'description'	=>	__('Category whose posts need to be featured..', 'ph-periodical'),
				'priority'		=>	10,
				'section'		=>	'phperiodical-ticker'
				
			)
		)
	);
		
	$wp_customize->add_setting(
		'phperiodical-ticker-count', array(
			'default'		=>	6,
			'sanitize_callback'	=>	'absint'
		)
	);
		
	$wp_customize->add_control( new WP_Customize_Control(
		$wp_customize,
		'phperiodical-ticker-count',
			array(
				'label'    => __( 'No. of Posts', 'ph-periodical' ),
				'description'    => __( 'Recommended to set this value to 6 or more.', 'ph-periodical' ),
				'section'  => 'phperiodical-ticker',
				'settings' => 'phperiodical-ticker-count',
				'type'     => 'number'
			)
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-ticker-disable-phone', array(
			'default'		=>	1,
			'sanitize_callback'	=>	'absint' 
		)
	);
	$wp_customize->add_control(
		'phperiodical-ticker-disable-phone', array(
			  'type' => 'checkbox',
			  'section'		=>	'phperiodical-ticker',
			  'label' => __( 'Disable ticker on Mobile Devices','ph-periodical' ),
			  'description' => __( 'The Slider Ticker may not produce the desired effect on Mobile as it does on Desktop Devices. Use this to disable Ticker on Phone. (Recommended)','ph-periodical' ),
			)	
	);
	
	
		
	//Carousel
	$wp_customize->add_section(
		'phperiodical-carousel', array(
			'title'		=>	__('Featured Carousel', 'ph-periodical'),
			'priority'	=>	10,
			'panel'		=>	'phperiodical-featured-areas'
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-enable-carousel', array(
			'default'		=>	0,
			'sanitize_callback'	=>	'absint' 
		)
	);
	
	$wp_customize->add_control(
		'phperiodical-enable-carousel', array(
			  'type' => 'checkbox',
			  'section'		=>	'phperiodical-carousel',
			  'label' => __( 'Enable Carousel','ph-periodical' ),
			  'description' => __( 'A Sliding Carousel appears at the top of the Homepage, below the Menu Bar.','ph-periodical' ),
			)	
	);
	
	$wp_customize->add_setting(
		'phperiodical-carousel-cat', array(
			'default'		=>	0,
			'sanitize_callback'	=>	'absint'
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_WP_Customize_Category_Control(
			$wp_customize, 'phperiodical-carousel-cat', array(
				'label'		=>	__('Category', 'ph-periodical'),
				'description'	=>	__('Category whose posts need to be featured..', 'ph-periodical'),
				'priority'		=>	10,
				'section'		=>	'phperiodical-carousel'
				
			)
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-carousel-count', array(
			'default'		=>	6,
			'sanitize_callback'	=>	'absint'
		)
	);
	
	$wp_customize->add_control( new WP_Customize_Control(
		$wp_customize,
		'phperiodical-carousel-count',
			array(
				'label'    => __( 'No. of Posts', 'ph-periodical' ),
				'description'    => __( 'Recommended to set this value to 6 or more.', 'ph-periodical' ),
				'section'  => 'phperiodical-carousel',
				'settings' => 'phperiodical-carousel-count',
				'type'     => 'number'
			)
		)
	);
	
	//Featured Areas Section Generator
	$i = 0;
	for ($i = 1; $i < 8; $i++) :
		$wp_customize->add_section(
			'phperiodical-fa-'.$i, array(
				'title'		=>	__('Featured Posts Area - ', 'ph-periodical').$i,
				'priority'	=>	10,
				'panel'		=>	'phperiodical-featured-areas'
			)
		);
		
		//Enable
		$wp_customize->add_setting(
			'phperiodical-fa-enable-'.$i, array(
				'default'		=>	0,
				'sanitize_callback'	=>	'absint' 
			)
		);
		
		$wp_customize->add_control(
			'phperiodical-fa-enable-'.$i, array(
				  'type' => 'checkbox',
				  'section'		=>	'phperiodical-fa-'.$i,
				  'label' => __( 'Enable','ph-periodical' ),
				  'description' => __( 'Enable this Featured Area.','ph-periodical' ),
				)	
		);
		
		//Category Select Box
		$wp_customize->add_setting(
			'phperiodical-fa-cat-'.$i, array(
				'default'		=>	0,
				'sanitize_callback'	=>	'absint' 
			)
		);
		
		$wp_customize->add_control(
			new phperiodical_WP_Customize_Category_Control(
				$wp_customize, 'phperiodical-fa-cat-'.$i, array(
					'label'		=>	__('Category', 'ph-periodical'),
					'description'	=>	__('Category whose posts need to be featured', 'ph-periodical'),
					'priority'		=>	10,
					'section'		=>	'phperiodical-fa-'.$i,
				)
			)
		);
		
		//Show Title Checkbox
		$wp_customize->add_setting(
			'phperiodical-fa-show-title-'.$i, array(
				'default'		=>	0,
				'sanitize_callback'	=>	'absint' 
			)
		);
		
		$wp_customize->add_control(
			'phperiodical-fa-show-title-'.$i, array(
				  'type' => 'checkbox',
				  'section'		=>	'phperiodical-fa-'.$i,
				  'label' => __( 'Show Title','ph-periodical' ),
				  'description' => __( 'By Default, the category name will appear as the title above the featured section.','ph-periodical' ),
				)	
		);
		
		//Show Title Checkbox
		$wp_customize->add_setting(
			'phperiodical-fa-random-order-'.$i, array(
				'default'		=>	0,
				'sanitize_callback'	=>	'absint' 
			)
		);
		
		$wp_customize->add_control(
			'phperiodical-fa-random-order-'.$i, array(
				  'type' => 'checkbox',
				  'section'		=>	'phperiodical-fa-'.$i,
				  'label' => __( 'Random Post Order','ph-periodical' ),
				  'description' => __( 'By Default, the post are in descending order (newest first). Checking this will make it random.','ph-periodical' ),
				)	
		);
		
		$wp_customize->add_setting(
			'phperiodical-fa-style-'.$i, array(
				'default' => 'style1',
				'sanitize_callback'	=>	'phperiodical_sanitize_fa_style'
			)
		);
		
		$wp_customize->add_control(
			new phperiodical_Image_Radio_Control($wp_customize, 
				'phperiodical-fa-style-'.$i, array(
					'type' => 'radio',
					'label' => esc_html__('Select Featured Area Style', 'ph-periodical'),
					'section' => 'phperiodical-fa-'.$i,
					'settings' => 'phperiodical-fa-style-'.$i,
					'choices' => array(
						'style1' => get_template_directory_uri() . '/inc/customizer/images/fa-style1.png',
						'style2' => get_template_directory_uri() . '/inc/customizer/images/fa-style2.png',
						'style3' => get_template_directory_uri() . '/inc/customizer/images/fa-style3.png',
						'style4' => get_template_directory_uri() . '/inc/customizer/images/fa-style4.png',
						'style5' => get_template_directory_uri() . '/inc/customizer/images/fa-style5.png',
					)
				)
			)
		);
		
		
	endfor;	
	
}
add_action('customize_register', 'phperiodical_featured_areas_customize_register');