<?php
/**
 *	Basic Settings
 *  Background Image
 *  Homepage
 *  Archives
 *  Search Results Page
 *  Page Settings
 *  Single Post Settings
 *  404 Error Page
 */ 
function phperiodical_basic_settings_customize_register( $wp_customize ) {
	
	$wp_customize->add_panel(
		'phperiodical-basic-settings', array(
			'title'		=>	__('Basic Settings', 'ph-periodical'),
			'priority'	=>	20
		)
	);
	
	//Homepage Settings
	$wp_customize->add_section(
		'phperiodical-homepage', array(
			'title'		=>	__('Homepage (Blog)', 'ph-periodical'),
			'priority'	=>	10,
			'panel'		=>	'phperiodical-basic-settings'
		)
	);
	
	//Enable Latest Posts Section
	$wp_customize->add_setting(
		'phperiodical-enable-latest-posts', array(
			'default'		=>	1,
			'sanitize_callback'	=>	'absint' 
		)
	);
	
	$wp_customize->add_control(
		'phperiodical-enable-latest-posts', array(
			  'type' => 'checkbox',
			  'section'		=>	'phperiodical-homepage',
			  'label' => __( 'Enable Latest Posts Section','ph-periodical' ),
			  'description' => __( 'If you want to design your Homepage (Blog Page) using only the Featured Areas, then you can disable the latest posts area on homepage. (Optional).','ph-periodical' ),
			)	
	);
	
	$wp_customize->add_setting(
		'phperiodical-latest-post-title', array(
			'default'		=>	__('Latest Posts','ph-periodical'),
			'sanitize_callback'	=>	'sanitize_text_field' 
		)
	);
	
	$wp_customize->add_control(
		'phperiodical-latest-post-title', array(
			  'type' => 'text',
			  'section'		=>	'phperiodical-homepage',
			  'label' => __( 'Latest Posts Heading','ph-periodical' ),
			  'description' => __( 'The Heading of the Section which displays the latest posts on the homepage. Below all featured areas.','ph-periodical' ),
			  'active_callback' => function($control) {
				  return (true == $control->manager->get_setting('phperiodical-enable-latest-posts')->value());
			  },
			)	
	);
	
	$wp_customize->add_setting(
		'phperiodical-home-layout', array(
			'default' => 'style2',
			'sanitize_callback'	=>	'phperiodical_sanitize_fa_style'
		)
	);
		
	$wp_customize->add_control(
		new phperiodical_Image_Radio_Control($wp_customize, 
			'phperiodical-home-layout', array(
				'type' => 'radio',
				'label' => esc_html__('Latest Posts Style', 'ph-periodical'),
				'section' => 'phperiodical-homepage',
				'settings' => 'phperiodical-home-layout',
				'input_attrs' => array('class' => 'blog_layout_chooser'),
				'choices' => array(
					'style1' => get_template_directory_uri() . '/inc/customizer/images/content-style1.png',
					'style2' => get_template_directory_uri() . '/inc/customizer/images/content-style2.png',
					'style3' => get_template_directory_uri() . '/inc/customizer/images/content-style3.png',
					'style4' => get_template_directory_uri() . '/inc/customizer/images/content-style4.png',
				),
				'active_callback' => function($control) {
					  return (true == $control->manager->get_setting('phperiodical-enable-latest-posts')->value());
				 },
			)
		)
	);
	
		
		
	$wp_customize->add_setting(
			'phperiodical-primary-width-home', array(
				'default'	=>	'right-sidebar',
				'sanitize_callback'	=>	'phperiodical_sanitize_sidebar_layout'
			)
		);
		
	$wp_customize->add_control(
		new phperiodical_Image_Radio_Control($wp_customize, 
			'phperiodical-primary-width-home', array(
				'type' => 'radio',
				'label' => esc_html__('Sidebar Layout', 'ph-periodical'),
				'section' => 'phperiodical-homepage',
				'settings' => 'phperiodical-primary-width-home',
				'input_attrs' => array('class' => 'sidebar_layout_chooser'),
				'choices' => array(
					'no-sidebar' => get_template_directory_uri() . '/inc/customizer/images/sidebar-no.jpg',
					'right-sidebar' => get_template_directory_uri() . '/inc/customizer/images/sidebar-right.jpg',
					'right-sidebar-narrow' => get_template_directory_uri() . '/inc/customizer/images/sidebar-right-narrow.jpg',
					'no-sidebar-narrow-primary' => get_template_directory_uri() . '/inc/customizer/images/sidebar-no-narrow-primary.jpg',
				),
				'active_callback' => function($control) {
					  return (true == $control->manager->get_setting('phperiodical-enable-latest-posts')->value());
				},
			)
		)
	);
	
	//Background Image
	$wp_customize->get_section('background_image')->panel = 'phperiodical-basic-settings';
	$wp_customize->get_section('background_image')->priority = 5;
	
	//Archives
	$wp_customize->add_section(
		'phperiodical-archives', array(
			'title'		=>	__('Archives (Category/Tags)', 'ph-periodical'),
			'priority'	=>	10,
			'panel'		=>	'phperiodical-basic-settings'
		)
	);
	
	$wp_customize->add_setting('pixahive-archive-message', array(
		'sanitize_callback'	=>	'sanitize_text_field' 
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_Custom_Notice_Control(
			$wp_customize, 'pixahive-archive-message', array(
				'label'		=>	__('Archive Settings', 'ph-periodical'),
				'description'	=>	__('Use this section to customize the layout of Category and Tag Archive pages. This will also support any other custom taxonomies. Navigate to an archive page to view changes on the right side.', 'ph-periodical'),
				'priority'		=>	1,
				'section'		=>	'phperiodical-archives',
			)
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-archives-layout', array(
			'default' => 'style2',
			'sanitize_callback'	=>	'phperiodical_sanitize_fa_style'
		)
		);
		
	$wp_customize->add_control(
		new phperiodical_Image_Radio_Control($wp_customize, 
			'phperiodical-archives-layout', array(
				'type' => 'radio',
				'label' => esc_html__('Select Content Style', 'ph-periodical'),
				'section' => 'phperiodical-archives',
				'settings' => 'phperiodical-archives-layout',
				'input_attrs' => array('class' => 'blog_layout_chooser'),
				'choices' => array(
					'style1' => get_template_directory_uri() . '/inc/customizer/images/content-style1.png',
					'style2' => get_template_directory_uri() . '/inc/customizer/images/content-style2.png',
					'style3' => get_template_directory_uri() . '/inc/customizer/images/content-style3.png',
					'style4' => get_template_directory_uri() . '/inc/customizer/images/content-style4.png',
				)
			)
		)
	);
		
		
	$wp_customize->add_setting(
			'phperiodical-primary-width-archives', array(
				'default'	=>	'right-sidebar',
				'sanitize_callback'	=>	'phperiodical_sanitize_sidebar_layout'
			)
		);
		
	$wp_customize->add_control(
		new phperiodical_Image_Radio_Control($wp_customize, 
			'phperiodical-primary-width-archives', array(
				'type' => 'radio',
				'label' => esc_html__('Sidebar Layout', 'ph-periodical'),
				'section' => 'phperiodical-archives',
				'settings' => 'phperiodical-primary-width-archives',
				'input_attrs' => array('class' => 'sidebar_layout_chooser'),
				'choices' => array(
					'no-sidebar' => get_template_directory_uri() . '/inc/customizer/images/sidebar-no.jpg',
					'right-sidebar' => get_template_directory_uri() . '/inc/customizer/images/sidebar-right.jpg',
					'right-sidebar-narrow' => get_template_directory_uri() . '/inc/customizer/images/sidebar-right-narrow.jpg',
					'no-sidebar-narrow-primary' => get_template_directory_uri() . '/inc/customizer/images/sidebar-no-narrow-primary.jpg',
				)
			)
		)
	);
		
	//Page Settings.
	$wp_customize->add_section(
		'phperiodical-page-settings', array(
			'title'		=>	__('Pages', 'ph-periodical'),
			'priority'	=>	10,
			'panel'		=>	'phperiodical-basic-settings'
		)
	);
	
	$wp_customize->add_setting('pixahive-page-message', array(
		'sanitize_callback'	=>	'sanitize_text_field' 
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_Custom_Notice_Control(
			$wp_customize, 'pixahive-page-message', array(
				'label'		=>	__('Page Settings', 'ph-periodical'),
				'description'	=>	__('Use this section to customize the layout of pages of your site.', 'ph-periodical'),
				'priority'		=>	1,
				'section'		=>	'phperiodical-page-settings',
			)
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-primary-width-page', array(
				'default'	=>	'right-sidebar',
				'sanitize_callback'	=>	'phperiodical_sanitize_sidebar_layout'
			)
		);
		
	$wp_customize->add_control(
		new phperiodical_Image_Radio_Control($wp_customize, 
			'phperiodical-primary-width-page', array(
				'type' => 'radio',
				'label' => esc_html__('Sidebar Layout', 'ph-periodical'),
				'section' => 'phperiodical-page-settings',
				'settings' => 'phperiodical-primary-width-page',
				'input_attrs' => array('class' => 'sidebar_layout_chooser'),
				'choices' => array(
					'no-sidebar' => get_template_directory_uri() . '/inc/customizer/images/sidebar-no.jpg',
					'right-sidebar' => get_template_directory_uri() . '/inc/customizer/images/sidebar-right.jpg',
					'right-sidebar-narrow' => get_template_directory_uri() . '/inc/customizer/images/sidebar-right-narrow.jpg',
					'no-sidebar-narrow-primary' => get_template_directory_uri() . '/inc/customizer/images/sidebar-no-narrow-primary.jpg',
				)
			)
		)
	);
	
	//Single Post Settings.
	$wp_customize->add_section(
		'phperiodical-single-post', array(
			'title'		=>	__('Single Posts', 'ph-periodical'),
			'priority'	=>	10,
			'panel'		=>	'phperiodical-basic-settings'
		)
	);
	
	$wp_customize->add_setting('pixahive-single-post-message', array(
		'sanitize_callback'	=>	'sanitize_text_field' 
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_Custom_Notice_Control(
			$wp_customize, 'pixahive-single-post-message', array(
				'label'		=>	__('Single Post Settings', 'ph-periodical'),
				'description'	=>	__('Use this section to customize the layout of Single Posts. Navigate to one of the published posts to view changes on the right side.', 'ph-periodical'),
				'priority'		=>	1,
				'section'		=>	'phperiodical-single-post',
			)
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-single-post-style', array(
				'default'	=>	'style2',
				'sanitize_callback'	=>	'phperiodical_sanitize_fa_style'
			)
		);
		
	$wp_customize->add_control(
		new phperiodical_Image_Radio_Control($wp_customize, 
			'phperiodical-single-post-style', array(
				'type' => 'radio',
				'label' => esc_html__('Post Style', 'ph-periodical'),
				'section' => 'phperiodical-single-post',
				'settings' => 'phperiodical-single-post-style',
				'input_attrs' => array('class' => 'sidebar_layout_chooser'),
				'choices' => array(
					'style1' => get_template_directory_uri() . '/inc/customizer/images/single-style1.png',
					'style2' => get_template_directory_uri() . '/inc/customizer/images/single-style2.png',
				)
			)
		)
	);	
	
	$wp_customize->add_setting(
		'phperiodical-enable-author-bio', array(
			'default'		=>	0,
			'sanitize_callback'	=>	'absint' 
		)
	);
		
	$wp_customize->add_control(
		'phperiodical-enable-author-bio', array(
			  'type' => 'checkbox',
			  'section'		=>	'phperiodical-single-post',
			  'label' => __( 'Enable Author Bio','ph-periodical' ),
			  'description' => __( 'Show Author Bio below the post.','ph-periodical' ),
			)	
	);
	
	$wp_customize->add_setting(
		'phperiodical-primary-width-single-post', array(
				'default'	=>	'right-sidebar',
				'sanitize_callback'	=>	'phperiodical_sanitize_sidebar_layout'
			)
		);
		
	$wp_customize->add_control(
		new phperiodical_Image_Radio_Control($wp_customize, 
			'phperiodical-primary-width-single-post', array(
				'type' => 'radio',
				'label' => esc_html__('Sidebar Layout', 'ph-periodical'),
				'section' => 'phperiodical-single-post',
				'settings' => 'phperiodical-primary-width-single-post',
				'input_attrs' => array('class' => 'sidebar_layout_chooser'),
				'choices' => array(
					'no-sidebar' => get_template_directory_uri() . '/inc/customizer/images/sidebar-no.jpg',
					'right-sidebar' => get_template_directory_uri() . '/inc/customizer/images/sidebar-right.jpg',
					'right-sidebar-narrow' => get_template_directory_uri() . '/inc/customizer/images/sidebar-right-narrow.jpg',
					'no-sidebar-narrow-primary' => get_template_directory_uri() . '/inc/customizer/images/sidebar-no-narrow-primary.jpg',
				)
			)
		)
	);	
	
	//Search Results Page
	$wp_customize->add_section(
		'phperiodical-search-results', array(
			'title'		=>	__('Search Results Page', 'ph-periodical'),
			'priority'	=>	10,
			'panel'		=>	'phperiodical-basic-settings'
		)
	);
	
	$wp_customize->add_setting('pixahive-search-results-message', array(
		'sanitize_callback'	=>	'sanitize_text_field' 
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_Custom_Notice_Control(
			$wp_customize, 'pixahive-search-results-message', array(
				'label'		=>	__('Search Results Settings', 'ph-periodical'),
				'description'	=>	__('Use this section to customize the layout of results on Search Pages. Perform a search on the right hand side so you can view changes.', 'ph-periodical'),
				'priority'		=>	1,
				'section'		=>	'phperiodical-search-results',
			)
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-search-results-layout', array(
			'default' => 'style2',
			'sanitize_callback'	=>	'phperiodical_sanitize_fa_style'
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_Image_Radio_Control($wp_customize, 
			'phperiodical-search-results-layout', array(
				'type' => 'radio',
				'label' => esc_html__('Select Content Style', 'ph-periodical'),
				'section' => 'phperiodical-search-results',
				'settings' => 'phperiodical-search-results-layout',
				'input_attrs' => array('class' => 'blog_layout_chooser'),
				'choices' => array(
					'style1' => get_template_directory_uri() . '/inc/customizer/images/content-style1.png',
					'style2' => get_template_directory_uri() . '/inc/customizer/images/content-style2.png',
					'style3' => get_template_directory_uri() . '/inc/customizer/images/content-style3.png',
					'style4' => get_template_directory_uri() . '/inc/customizer/images/content-style4.png',
				)
			)
		)
	);
	
	
	$wp_customize->add_setting(
		'phperiodical-primary-width-search', array(
			'default'	=>	'right-sidebar',
			'sanitize_callback'	=>	'phperiodical_sanitize_sidebar_layout'
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_Image_Radio_Control($wp_customize, 
			'phperiodical-primary-width-search', array(
				'type' => 'radio',
				'label' => esc_html__('Sidebar Layout', 'ph-periodical'),
				'section' => 'phperiodical-search-results',
				'settings' => 'phperiodical-primary-width-search',
				'input_attrs' => array('class' => 'sidebar_layout_chooser'),
				'choices' => array(
					'no-sidebar' => get_template_directory_uri() . '/inc/customizer/images/sidebar-no.jpg',
					'right-sidebar' => get_template_directory_uri() . '/inc/customizer/images/sidebar-right.jpg',
					'right-sidebar-narrow' => get_template_directory_uri() . '/inc/customizer/images/sidebar-right-narrow.jpg',
					'no-sidebar-narrow-primary' => get_template_directory_uri() . '/inc/customizer/images/sidebar-no-narrow-primary.jpg',
				)
			)
		)
	);
	
	
	//404 Error Page Settings.
	$wp_customize->add_section(
		'phperiodical-404-error', array(
			'title'		=>	__('404 Error Page', 'ph-periodical'),
			'priority'	=>	10,
			'panel'		=>	'phperiodical-basic-settings'
		)
	);
	
	$wp_customize->add_setting('pixahive-404page-message', array(
		'sanitize_callback'	=>	'sanitize_text_field' 
		)
	);
	
	$wp_customize->add_control(
		new phperiodical_Custom_Notice_Control(
			$wp_customize, 'pixahive-404page-message', array(
				'label'		=>	__('404 Page', 'ph-periodical'),
				'description'	=>	__('Use this page to customize the 404 Error Page.', 'ph-periodical'),
				'priority'		=>	1,
				'section'		=>	'phperiodical-404-error',
			)
		)
	);
	
	$wp_customize->add_setting(
		'phperiodical-enable-404-posts', array(
			'default'		=>	1,
			'sanitize_callback'	=>	'absint' 
		)
	);
		
	$wp_customize->add_control(
		'phperiodical-enable-404-posts', array(
			  'type' => 'checkbox',
			  'section'		=>	'phperiodical-404-error',
			  'label' => __( 'Show Latest Posts on 404 Page','ph-periodical' ),
			)	
	);
	
	
	
}
add_action('customize_register', 'phperiodical_basic_settings_customize_register');